﻿using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataService.ModelsEnumTypes;

namespace PpmsDataService.Models
{
    public class ProviderContact
    {
        [Key]
        public string FullName { get; set; }

        public string CompanyName { get; set; }

        public virtual IQueryable<Provider> Company { get; set; }
      
        public bool IsVeteran { get; set; }

        public string EmergencyResponderIndicator { get; set; }

        public bool IsOtherPartyContact { get; set; }

        public string ProviderName { get; set; }

        public virtual IQueryable<Provider> Provider { get; set; }

        public string BusinessPhone { get; set; }

        public string MobilePhone { get; set; }

        public string Email { get; set; }

        public string Fax { get; set; }

        public PreferredMethodOfContact PreferredMethodOfContact { get; set; }

        public DeliveryStatus DeliveryStatus { get; set; }

        public string Address { get; set; }

        public string AddressStreet1 { get; set; }

        public string AddressStreet2 { get; set; }

        public string AddressCity { get; set; }

        public string AddressState { get; set; }

        public string AddressZip { get; set; }

        public string AddressCountryRegion { get; set; }

        public bool IsAddressActive { get; set; }

        public bool IsMailingAddress { get; set; }

        public AddressInvalidReason AddressInvalidReason { get; set; }

        public string CountryCodeName { get; set; }

        public Gender Gender { get; set; }

        public MaritalStatus MaritalStatus { get; set; }

        public string SpousePartnerName { get; set; }

        public string Birthday { get; set; }

        public string Anniversary { get; set; }

        public string DateOfDeath { get; set; }

        public bool AllowEmail { get; set; }
    
        public bool AllowFollowEmail { get; set; }

        public bool AllowBulkEmail { get; set; }

        public bool AllowPhone { get; set; }

        public bool AllowFax { get; set; }

        public bool AllowMail { get; set; }

        public bool IsTextingAcceptable { get; set; }

        public string PersonalNotes { get; set; }

        public virtual IQueryable<CareSite> CareSites { get; set; }

    }
}